/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.monitor;

import filenet.pa.admin.IPAAdministration;
import filenet.pa.admin.PAStatisticsSnapShot;
import filenet.pa.main.DTSStatisticsSnapShot;
import filenet.pa.publisher.PublisherStatisticsSnapShot;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.base.VWDebug;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PAStatisticsCollectionThread {
    private PANode m_paNode = null;
    private boolean m_bRunning = false;
    private SimpleDateFormat m_dateFormat = new SimpleDateFormat("MM/dd/yy hh:mm:ss aa");

    public PAStatisticsCollectionThread(PANode paNode) {
        this.m_paNode = paNode;
    }

    public synchronized void start() {
        final PAStatisticsCollectionThread objInstance = this;
        if (!this.m_bRunning && this.m_paNode.getBooleanProperty("TaskManager.CaseAnalyzer.CollectStatistics")) {
            this.m_bRunning = true;
            Runnable runner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (PAStatisticsCollectionThread.this.m_bRunning) {
                        IPAAdministration paAdmin = PAStatisticsCollectionThread.this.m_paNode.getPAAdministration();
                        if (paAdmin == null) continue;
                        try {
                            PAStatisticsCollectionThread.this.writeStatistics();
                            if (PAStatisticsCollectionThread.this.m_paNode.getBooleanProperty("TaskManager.CaseAnalyzer.CollectStatistics.Reset")) {
                                paAdmin.resetStatistics();
                            }
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex, "Exception while collecting statistics.");
                        }
                        Object object = objInstance;
                        synchronized (object) {
                            try {
                                objInstance.wait(VWTaskUtil.parseInt(PAStatisticsCollectionThread.this.m_paNode.getProperty("TaskManager.CaseAnalyzer.CollectStatistics.Interval"), 5) * 60 * 1000);
                            }
                            catch (InterruptedException ex) {
                                VWDebug.logException(ex, "Statistic collector thread interruppted.");
                            }
                        }
                    }
                }
            };
            Thread thread = new Thread(runner);
            thread.setName(PAStatisticsCollectionThread.class.getName());
            thread.start();
        }
    }

    public synchronized void stop() {
        this.m_bRunning = false;
        this.notifyAll();
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatistics() throws Exception {
        PrintWriter writer = null;
        try {
            File file = new File(this.m_paNode.getInstallDirectory() + File.separator + "pastats.csv");
            boolean bWriteHeader = !file.exists();
            writer = new PrintWriter(new FileWriter(file.getPath(), true));
            PAStatisticsSnapShot stats = this.m_paNode.getPAAdministration().getStatistics();
            DTSStatisticsSnapShot dtsStats = stats.getDTSStats();
            PublisherStatisticsSnapShot pubStats = stats.getPublisherStats();
            if (pubStats == null || dtsStats == null) {
                return;
            }
            if (bWriteHeader) {
                writer.println("Time Stamp,Dimension cache hit ratio,Fact table cache hit ratio,Avg events published /sec,Avg database update time (sec),Process Engine events published,Content Engine events published,Avg cube processing time (sec), Avg publishing interval cube processing time (sec)");
            }
            writer.print(this.m_dateFormat.format(new Date()));
            writer.print(",");
            writer.print(pubStats.getDimensionCacheHitRate());
            writer.print(",");
            writer.print(pubStats.getFactCacheHitRate());
            writer.print(",");
            writer.print(pubStats.getAvgEventsPublishedPerSec());
            writer.print(",");
            writer.print(pubStats.getAvgDatabaseUpdateTimeInSec());
            writer.print(",");
            writer.print(pubStats.getPEEventsPublishedSinceReset());
            writer.print(",");
            writer.print(pubStats.getCEEventsPublishedSinceReset());
            writer.print(",");
            writer.print(dtsStats.getAvgCubeProcessingTimeInSec());
            writer.print(",");
            writer.print(dtsStats.getAvgWIPCubeProcessingTimeInSec());
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

